let date = new Date();

function renderCalendar() {
    const monthYear = document.getElementById("monthYear");
    const dates = document.getElementById("dates");

    const year = date.getFullYear();
    const month = date.getMonth();

    const firstDay = new Date(year, month, 1).getDay();
    const lastDate = new Date(year, month + 1, 0).getDate();

    const months = [
        "Januari", "Februari", "Maret", "April", "Mei", "Juni",
        "Juli", "Agustus", "September", "Oktober", "November", "Desember"
    ];

    monthYear.innerText = `${months[month]} ${year}`;
    dates.innerHTML = "";

    for (let i = 0; i < firstDay; i++) {
        dates.innerHTML += "<div></div>";
    }

    for (let i = 1; i <= lastDate; i++) {
        let today = new Date();
        let isToday =
            i === today.getDate() &&
            month === today.getMonth() &&
            year === today.getFullYear();

        dates.innerHTML += `<div class="${isToday ? 'today' : ''}">${i}</div>`;
    }
}

function prevMonth() {
    date.setMonth(date.getMonth() - 1);
    renderCalendar();
}

function nextMonth() {
    date.setMonth(date.getMonth() + 1);
    renderCalendar();
}

renderCalendar();
