<?php
if (!defined('INDEX')) header("Location: ../login.php");

$id = $_GET['id'] ?? null;
if (!$id) {
    echo "<p>ID tidak ditemukan!</p>";
    exit;
}

// Ambil data booking berdasar id
$query = "SELECT * FROM booking WHERE id_pemesanan = '$id'";
$result = mysqli_query($con, $query);
$data = mysqli_fetch_assoc($result);

if (!$data) {
    echo "<p>Data tidak ditemukan!</p>";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Edit Pesanan</title>
  <link rel="stylesheet" href="bower_components/bootstrap/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="css/form.css">
</head>
<body>

<h2 class="judul">Edit Pesanan</h2>

<form action="?hal=booking_update" method="post" enctype="multipart/form-data">
  <!-- ID Hidden untuk update -->
  <input type="hidden" name="id" value="<?= htmlspecialchars($data['id_pemesanan']) ?>">

  <div class="form-group">
      <label for="nama">Nama Lengkap</label>
      <input type="text" name="nama" id="nama" class="form-control" 
             value="<?= htmlspecialchars($data['nama_lengkap']) ?>" required>
  </div>

  <div class="form-group">
      <label for="alamat">Alamat</label>
      <input type="text" name="alamat" id="alamat" class="form-control" 
             value="<?= htmlspecialchars($data['alamat']) ?>" required>
  </div>

  <div class="form-group">
      <label for="hp">No Tlpn</label>
      <input type="tel" name="hp" id="hp" class="form-control" 
             value="<?= htmlspecialchars($data['no_tlp']) ?>" required>
  </div>

  <div class="form-group">
      <label>Metode Pembayaran</label><br>
      <?php
      $methods = ['lunas' => 'Lunas', 'dp' => 'DP', 'belumbayar' => 'Belum bayar'];
      foreach ($methods as $value => $label) {
          $checked = ($data['metode_pembayaran'] == $value) ? 'checked' : '';
          echo "<label><input type='radio' name='bayar' value='$value' $checked required> $label </label> ";
      }
      ?>
  </div>

  <div class="form-group">
      <label for="paket">Paket Dekorasi</label>
      <select name="paket" id="paket" class="form-control" required>
          <option value="">- Pilih Paket -</option>
          <?php
          $paketQuery = "SELECT * FROM paket";
          $paketResult = mysqli_query($con, $paketQuery);
          while ($paket = mysqli_fetch_assoc($paketResult)) {
              $selected = ($paket['id_paket'] == $data['paket_dekorasi']) ? 'selected' : '';
              echo "<option value='{$paket['id_paket']}' $selected>{$paket['nama_paket']}</option>";
          }
          ?>
      </select>
  </div>

  <div class="form-group">
      <label for="tanggalpasang">Tanggal Pemasangan</label>
      <input type="date" name="tanggalpasang" id="tanggalpasang" class="form-control" 
             value="<?= htmlspecialchars($data['tanggal_pemasangan']) ?>" required>
  </div>

  <div class="form-group">
      <label for="tanggalbongkar">Tanggal Pembongkaran</label>
      <input type="date" name="tanggalbongkar" id="tanggalbongkar" class="form-control" 
             value="<?= htmlspecialchars($data['tanggal_pembongkaran']) ?>" required>
  </div>

  <div class="form-group">
      <label for="catatan">Catatan</label>
      <textarea name="catatan" id="catatan" class="form-control" rows="4"><?= htmlspecialchars($data['catatan']) ?></textarea>
  </div>

  <div class="form-group">
      <button type="submit" class="btn btn-primary">Update</button>
      <a href="?hal=booking" class="btn btn-default">Batal</a>
  </div>
</form>

<script src="bower_components/jquery/dist/jquery.min.js"></script>
<script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>
</body>
</html>