<?php
include "library/config.php";

// ambil bulan & tahun (PAKAI ANGKA, bukan "02")
$bulan = isset($_GET['bulan']) ? (int)$_GET['bulan'] : (int)date('n');
$tahun = isset($_GET['tahun']) ? (int)$_GET['tahun'] : date('Y');

// prev & next
$prevBulan = $bulan - 1;
$nextBulan = $bulan + 1;
$prevTahun = $tahun;
$nextTahun = $tahun;

if ($prevBulan < 1) {
    $prevBulan = 12;
    $prevTahun--;
}

if ($nextBulan > 12) {
    $nextBulan = 1;
    $nextTahun++;
}

// nama bulan
$namaBulan = [
1=>"Januari","Februari","Maret","April","Mei","Juni",
"Juli","Agustus","September","Oktober","November","Desember"
];

// info kalender
$jumlahHari = cal_days_in_month(CAL_GREGORIAN,$bulan,$tahun);
$hariAwal = date('N', strtotime("$tahun-$bulan-01"));
?>
<!DOCTYPE html>
<html>
<head>
<title>Kalender Booking</title>
<style>
body{font-family:Arial;background:#f4f6f9}
h2{text-align:center}
.nav{text-align:center;margin:15px}

table{border-collapse:collapse;margin:auto;background:white}
th{background:#007bff;color:white;padding:8px}
td{border:1px solid #ddd;width:140px;height:110px;vertical-align:top;padding:5px}

.tanggal{font-weight:bold}
.pasang{color:green;font-size:12px}
.bongkar{color:red;font-size:12px}

a{text-decoration:none;font-weight:bold;color:#007bff}
</style>
</head>
<body>

<h2>Kalender Jadwal Dekorasi</h2>

<div class="nav">
<a href="?bulan=<?=$prevBulan?>&tahun=<?=$prevTahun?>">◀</a>
<b><?=$namaBulan[$bulan]?> <?=$tahun?></b>
<a href="?bulan=<?=$nextBulan?>&tahun=<?=$nextTahun?>">▶</a>
</div>

<table>
<tr>
<th>Sen</th><th>Sel</th><th>Rab</th>
<th>Kam</th><th>Jum</th><th>Sab</th><th>Min</th>
</tr>
<tr>

<?php
// kosong sebelum tanggal 1
for($i=1;$i<$hariAwal;$i++){
    echo "<td></td>";
}

for($tgl=1;$tgl<=$jumlahHari;$tgl++){

    // FORMAT TANGGAL BENAR (YYYY-MM-DD)
    $tanggal = $tahun . "-" . sprintf("%02d",$bulan) . "-" . sprintf("%02d",$tgl);

    echo "<td><div class='tanggal'>$tgl</div>";

    // PEMASANGAN
    $pasang = mysqli_query($con,
        "SELECT nama_lengkap FROM booking
         WHERE tanggal_pemasangan='$tanggal'");

    while($p=mysqli_fetch_assoc($pasang)){
        echo "<div class='pasang'>Pasang: ".$p['nama_lengkap']."</div>";
    }

    // PEMBONGKARAN
    $bongkar = mysqli_query($con,
        "SELECT nama_lengkap FROM booking
         WHERE tanggal_pembongkaran='$tanggal'");

    while($b=mysqli_fetch_assoc($bongkar)){
        echo "<div class='bongkar'>Bongkar: ".$b['nama_lengkap']."</div>";
    }

    echo "</td>";

    if( ($tgl+$hariAwal-1) % 7 == 0 ){
        echo "</tr><tr>";
    }
}
?>

</tr>
</table>

</body>
</html>