<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Dashboard Wedding Decoration - Famela Decoration Madiun</title>

<!-- Google Font -->
<link href="https://fonts.googleapis.com/css?family=Poppins:400,600&display=swap" rel="stylesheet" />

<style>
  /* Main Content */
..main {
  margin-left: 270px;
  padding: 40px 20px 40px 20px; /* padding kiri 20px biar lebih rapat */
  background: #fff;
  min-height: 100vh;

}

/* Topbar */
.topbar {
  display: flex;
  justify-content: space-between;
  align-items: center;
  margin-bottom: 40px;
}

.topbar h1 {
  font-weight: 700;
  font-size: 3rem; /* diperbesar dari 2.5rem */
  color: #4a90e2;
}

.search-box input {
  padding: 10px 14px;
  width: 320px;
  border: 2px solid #4a90e2;
  border-radius: 8px;
  font-size: 1.2rem; /* diperbesar dari 1rem */
  outline: none;
  transition: 0.3s;
}

.search-box input:focus {
  border-color: #2c63c9;
  box-shadow: 0 0 8px #2c63c9;
}

/* Welcome section */
.welcome {
  background: #f0f5fb;
  border-left: 6px solid #4a90e2;
  padding: 30px 35px; /* padding lebih lega */
  border-radius: 8px;
  margin-bottom: 50px;
  font-size: 1.4rem; /* diperbesar dari 1.2rem */
  line-height: 1.8;
  color: #2c3e50;
}

/* Cards container */
.cards {
  display: flex;
  gap: 30px;
  flex-wrap: wrap;
  justify-content: flex-start;
}

/* Single card */
.card {
  background: #ffffff;
  box-shadow: 0 6px 15px rgba(74, 144, 226, 0.15);
  border-radius: 14px;
  width: 340px; /* sedikit diperbesar dari 320px */
  overflow: hidden;
  transition: transform 0.3s ease;
  cursor: pointer;
}

.card:hover {
  transform: translateY(-8px);
  box-shadow: 0 12px 20px rgba(74, 144, 226, 0.25);
}

.card img {
  width: 100%;
  height: 200px;
  object-fit: cover;
}

.card-content {
  padding: 20px 25px; /* padding lebih luas */
}

.card-content h3 {
  font-size: 1.8rem; /* diperbesar dari 1.5rem */
  margin-bottom: 14px;
  color: #4a90e2;
}

.card-content p {
  font-size: 1.2rem; /* diperbesar dari 1rem */
  color: #555;
  margin-bottom: 18px;
}

.card-content .price {
  font-weight: 700;
  font-size: 1.3rem; /* diperbesar dari 1.1rem */
  color: #2c63c9;
}
 /* Container tombol di bawah paket */
.booking-container{
  display: flex;
  justify-content: center;   /* tengah horizontal */
  margin-top: 60px;          /* jarak dari daftar paket (agak ke bawah) */
  margin-bottom: 40px;
}

/* Tombol booking */
.btn-booking{
  background: linear-gradient(135deg, #c9a96e, #e8d3a9);
  color: white;
  padding: 14px 45px;
  font-size: 18px;
  font-weight: 600;
  text-decoration: none;
  border-radius: 50px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.15);
  transition: all 0.3s ease;
  letter-spacing: 1px;
}

/* Efek hover */
.btn-booking:hover{
  transform: translateY(-3px);
  box-shadow: 0 10px 25px rgba(0,0,0,0.25);
  background: linear-gradient(135deg, #b8965a, #d9c08a);
}

/* Footer */
/* footer {
  text-align: center;
  padding: 20px 0;
  margin-top: 60px;
  color: #888;
  font-size: 1rem;  diperbesar dari 0.9rem 
} */

/* Responsive */
@media(max-width: 1024px) {
  .cards {
    justify-content: center;
  }
}

@media(max-width: 768px) {
  body {
    flex-direction: column;
  }
  .sidebar {
    position: relative;
    width: 100%;
    height: auto;
    padding: 20px;
  }
  .main {
    margin-left: 0;
    padding: 20px;
  }
  .topbar h1 {
    font-size: 2.2rem; /* sedikit diperbesar dari 2rem */
  }
  .search-box input {
    width: 100%;
    font-size: 1.1rem; /* diperbesar dari 1rem */
  }
  .cards {
    flex-direction: column;
    align-items: center;
  }
  .card {
    width: 95%; /* lebih besar di mobile */

  }

 
}
</style>
</head>
<body>
<!-- Main Content -->
<div class="main">

  <!-- Topbar -->
  <div class="topbar">
    <h1>Selamat Datang di Dashboard Famela Decoration</h1>
    <div class="search-box">
      <input type="text" placeholder="Cari paket dekorasi..."/>
    </div>
  </div>

  <!-- Welcome Section -->
  <section class="welcome">
    <p>
      “Mewujudkan impian pernikahan Anda dengan sentuhan elegan dan dekorasi yang memukau. Famela Decoration Madiun hadir untuk memberikan nuansa istimewa di hari spesial Anda, 
      dengan konsep kreatif dan profesionalisme yang tak tertandingi.”
    </p>
  </section>

  <!-- Cards Section -->
  <section class="cards">

    <div class="card">
      <img src="images/download (1).jfif" alt="Dekorasi Pernikahan 1" />
      <div class="card-content">
        <h3>Paket Elegan Classic</h3>
        <p>Sentuhan klasik dengan warna putih dan gold.</p>
        <span class="price">Mulai Rp 12.000.000</span>
      </div>
    </div>

    <div class="card">
      <img src="https://images.unsplash.com/photo-1542254623-097e32f6afba?auto=format&fit=crop&w=800&q=80" alt="Dekorasi Pernikahan 2" />
      <div class="card-content">
        <h3>Paket Modern Minimalis</h3>
        <p>Desain minimalis dengan aksen biru pastel dan bunga segar.</p>
        <span class="price">Mulai Rp 15.000.000</span>
      </div>
    </div>

    <div class="card">
      <img src="https://images.unsplash.com/photo-1506459225024-1428097a7e18?auto=format&fit=crop&w=800&q=80" alt="Dekorasi Pernikahan 3" />
      <div class="card-content">
        <h3>Paket Rustic Romantis</h3>
        <p>Nuansa hangat dengan dekor kayu dan lampu-lampu cantik.</p>
        <span class="price">Mulai Rp 10.000.000</span>
      </div>
    </div>
   
  </section>

 <div class="booking-container">
  <a href="?hal=booking" class="btn-booking">Booking Sekarang</a>
</div>

</div>

</body>
</html>