<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SMK BP Subulul Huda</title>
    
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    
    <style>
        body, html {
            height: 100%;
            margin: 0;
            background-color: #f8f9fa;
        }
        
        /* Background Utama */
        .login-wrapper {
            background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)), url('css/web.webp');
            background-size: cover;
            background-position: center;
            min-height: 100vh;
            display: flex;
            align-items: center;
        }

        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.3);
            border: none;
            padding: 30px;
        }

        .brand-text {
            color: #ffffff;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.5);
        }

        .btn-custom {
            background-color: #00a65a;
            color: white;
            font-weight: bold;
            border-radius: 50px;
            transition: 0.3s;
        }

        .btn-custom:hover {
            background-color: #008d4c;
            transform: translateY(-2px);
            color: white;
        }

        .input-group-text {
            background: transparent;
            border-right: none;
        }

        .form-control {
            border-left: none;
        }

        @media (max-width: 768px) {
            .brand-text {
                text-align: center;
                margin-bottom: 40px;
            }
        }
    </style>
</head>
<body>

<div class="login-wrapper">
    <div class="container">
        <div class="row align-items-center">
            
            <div class="col-lg-7 brand-text">
                <h1 class="display-4 font-weight-bold">SMK BP Subulul Huda</h1>
                <h3 class="mt-3">System Informasi Pelaporan Pelanggaran</h3>
                <p class="lead">"Melalui sistem ini, kami berkomitmen untuk menciptakan lingkungan sekolah yang transparan, adil, dan harmonis."</p>
                <div class="mt-4">
                    <a href="about.html" class="btn btn-outline-light btn-sm"><i class="fa fa-info-circle"></i> Visi & Misi</a>
                </div>
            </div>

            <div class="col-lg-5">
                <div class="card login-card">
                    <div class="card-body">
                        <div class="text-center mb-4">
                            <h2 class="font-weight-bold">SIGN IN</h2>
                            <p class="text-muted">Gunakan akun admin Anda</p>
                        </div>
                        
                        <form action="ceklogin.php" method="post">
                            <div class="form-group">
                                <label>Username</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fa fa-user"></i></span>
                                    </div>
                                    <input type="text" name="username" class="form-control" placeholder="Masukkan username" required>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Password</label>
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"><i class="fa fa-lock"></i></span>
                                    </div>
                                    <input type="password" name="password" class="form-control" placeholder="Masukkan password" required>
                                </div>
                            </div>
                            
                            <button type="submit" class="btn btn-custom btn-block btn-lg mt-4 shadow-sm">
                                MASUK SEKARANG <i class="fa fa-sign-in-alt ml-2"></i>
                            </button>
                        </form>
                        
                        <div class="text-center mt-4">
                            <small class="text-muted">
                                Made With <i class="fa fa-heart text-danger"></i> by TechnoMancers &copy; 2026
                            </small>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

</body>
</html>