<?php if(!defined('INDEX')) die(); ?>

<section class="content-header">
    <h1><i class="fa fa-heartbeat text-green"></i> Penebusan Poin Siswa</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-4">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">Langkah 1: Cari Siswa</h3>
                </div>
                <div class="box-body">
                    <form action="" method="get">
                        <input type="hidden" name="hal" value="tebus_tambah">
                        <div class="input-group">
                            <input type="number" name="nis" class="form-control" placeholder="Masukkan NIS..." value="<?= @$_GET['nis'] ?>" required>
                            <span class="input-group-btn">
                                <button type="submit" class="btn btn-success btn-flat"><i class="fa fa-search"></i> Cek</button>
                            </span>
                        </div>
                    </form>
                </div>
            </div>

            <?php
            if(isset($_GET['nis']) && !empty($_GET['nis'])){
                $nis = mysqli_real_escape_string($con, $_GET['nis']);
                $query = mysqli_query($con, "SELECT * FROM siswa WHERE nis = '$nis'");
                if($data = mysqli_fetch_assoc($query)){
            ?>
            <div class="box box-widget widget-user-2">
                <div class="widget-user-header bg-green">
                    <div class="widget-user-image">
                        <img class="img-circle" src="images/<?= $data['foto'] ?: 'default.png' ?>" alt="User Avatar" style="width:65px; height:65px; object-fit:cover;">
                    </div>
                    <h3 class="widget-user-username"><?= $data['nama_siswa'] ?></h3>
                    <h5 class="widget-user-desc">NIS: <?= $data['nis'] ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked">
                        <li><a href="#">Kelas <span class="pull-right badge bg-blue"><?= $data['kelas'] ?></span></a></li>
                        <li><a href="#">Jurusan <span class="pull-right badge bg-aqua"><?= $data['jurusan'] ?></span></a></li>
                        <li><a href="#">Total Poin Pelanggaran <span class="pull-right badge bg-red" style="font-size:14px;"><?= $data['poin_sis'] ?> Pts</span></a></li>
                    </ul>
                </div>
            </div>
            <?php 
                } else {
                    echo "<div class='alert alert-danger'><i class='fa fa-warning'></i> Siswa tidak ditemukan!</div>";
                }
            } 
            ?>
        </div>

        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Langkah 2: Detail Penebusan</h3>
                </div>
                
                <form action="?hal=tebus_insert" method="post">
                    <div class="box-body">
                        <?php if(isset($data) && $data): ?>
                        <input type="hidden" name="id" value="<?= $data['id_siswa'] ?>">
                        <input type="hidden" name="nis" value="<?= $data['nis'] ?>">
                        <input type="hidden" name="nama_siswa" value="<?= $data['nama_siswa'] ?>">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Gender</label>
                                    <input type="text" class="form-control" value="<?= $data['gender'] ?>" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tanggal Tebus</label>
                                    <input type="date" name="tgl_tebus" class="form-control" value="<?= date('Y-m-d') ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label>Pilih Jenis Penebusan (Aksi Positif)</label>
                            <select class="form-control select2" style="width: 100%;" name="tebus" id="tebus" required>
                                <option value=""> - Pilih Penebusan - </option>
                                <?php
                                $query_tebus = mysqli_query($con, "SELECT * FROM tebus");
                                while($dt_tebus = mysqli_fetch_assoc($query_tebus)){
                                    echo "<option value='$dt_tebus[kode_tebus]'> $dt_tebus[nama_tebus] | Potongan: $dt_tebus[poin_tebus] Poin </option>";
                                }
                                ?>
                            </select>
                        </div>

                        <div class="alert alert-info shadow-sm" style="background-color: #d9edf7 !important; border-color: #bce8f1 !important; color: #31708f !important;">
                            <i class="fa fa-info-circle"></i> <b>Informasi:</b> Penebusan poin ini akan secara otomatis <b>mengurangi</b> total poin pelanggaran siswa tersebut.
                        </div>

                        <?php else: ?>
                        <div class="text-center" style="padding: 60px 0;">
                            <i class="fa fa-search fa-4x text-gray"></i>
                            <p class="text-muted mt-3">Silakan cari data siswa terlebih dahulu di kolom sebelah kiri.</p>
                        </div>
                        <?php endif; ?>
                    </div>

                    <?php if(isset($data) && $data): ?>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary btn-lg btn-block shadow"><i class="fa fa-save"></i> SIMPAN PENEBUSAN</button>
                        <button type="reset" class="btn btn-default btn-block">Reset Form</button>
                    </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</section>