<?php
if (!defined('INDEX')) die();

// Ambil data dengan JOIN agar bisa filter Kelas & Jurusan
$query = "SELECT rt.*, s.kelas, s.jurusan, s.foto 
          FROM rw_tebus rt 
          JOIN siswa s ON rt.nis = s.nis 
          ORDER BY rt.id_rwt DESC";
$result = mysqli_query($con, $query);
?>

<section class="content-header">
    <h1><i class="fa fa- history text-green"></i> Riwayat Penebusan Poin</h1>
</section>

<section class="content">
    <div class="box box-success">
        <div class="box-header with-border">
            <div class="row">
                <div class="col-md-3">
                    <a href="?hal=tebus_tambah" class="btn btn-success btn-block">
                        <i class="fa fa-plus"></i> Tambah Penebusan
                    </a>
                </div>
                <div class="col-md-9 text-right">
                    <input type="text" id="searchInput" onkeyup="filterTable()" placeholder="Cari nama siswa..." class="form-control" style="width: 200px; display:inline-block;">
                    
                    <select id="filterKelas" class="form-control" style="width: 130px; display:inline-block;" onchange="filterTable()">
                        <option value="">Semua Kelas</option>
                        <option value="10">Kelas 10</option>
                        <option value="11">Kelas 11</option>
                        <option value="12">Kelas 12</option>
                    </select>

                    <select id="filterJurusan" class="form-control" style="width: 150px; display:inline-block;" onchange="filterTable()">
                        <option value="">Semua Jurusan</option>
                        <?php
                        $jurusanQuery = mysqli_query($con, "SELECT DISTINCT jurusan FROM siswa");
                        while ($row = mysqli_fetch_array($jurusanQuery)) {
                            echo "<option value='".$row['jurusan']."'>".$row['jurusan']."</option>";
                        }
                        ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="box-body table-responsive no-padding">
            <table id="tableTebus" class="table table-hover">
                <thead>
                    <tr style="background: #f4f4f4;">
                        <th width="50">No</th>
                        <th>Siswa</th>
                        <th>NISN</th>
                        <th>Kelas / Jurusan</th>
                        <th>Waktu Menebus</th>
                        <th>Poin</th>
                        <th width="100">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 0;
                    while($data = mysqli_fetch_array($result)){
                        $no++;
                    ?>
                    <tr>
                        <td><?= $no ?></td>
                        <td>
                            <img src="images/<?= $data['foto'] ?: 'default.png' ?>" class="img-circle" style="width:30px; height:30px; margin-right:10px; object-fit:cover;">
                            <b><?= $data['nama'] ?></b>
                        </td>
                        <td><span class="text-muted"><?= $data['nis'] ?></span></td>
                        <td>
                            <span class="label label-default"><?= $data['kelas'] ?> - <?= $data['jurusan'] ?></span>
                        </td>
                        <td><i class="fa fa-calendar"></i> <?= date('d M Y', strtotime($data['tanggal'])) ?></td>
                        <td><b class="text-green">- <?= $data['poin'] ?> Pts</b></td>
                        <td>
                            <a href="?hal=tebus_hapus&id=<?= $data['id_rwt'] ?>" 
                               class="btn btn-danger btn-xs" 
                               onclick="return confirm('Yakin ingin menghapus riwayat ini? Poin siswa akan dikembalikan.')">
                                <i class="fa fa-trash"></i> Hapus
                            </a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

<script>
function filterTable() {
    var inputNama = document.getElementById("searchInput").value.toUpperCase();
    var filterKelas = document.getElementById("filterKelas").value.toUpperCase();
    var filterJurusan = document.getElementById("filterJurusan").value.toUpperCase();
    var table = document.getElementById("tableTebus");
    var tr = table.getElementsByTagName("tr");

    for (var i = 1; i < tr.length; i++) {
        var tdNama = tr[i].getElementsByTagName("td")[1]; // Kolom Nama
        var tdKelasJurusan = tr[i].getElementsByTagName("td")[3]; // Kolom Kelas/Jurusan

        if (tdNama && tdKelasJurusan) {
            var txtNama = tdNama.textContent || tdNama.innerText;
            var txtKJ = tdKelasJurusan.textContent || tdKelasJurusan.innerText;

            // Logika filter gabungan
            var matchNama = txtNama.toUpperCase().indexOf(inputNama) > -1;
            var matchKelas = filterKelas === "" || txtKJ.toUpperCase().indexOf(filterKelas) > -1;
            var matchJurusan = filterJurusan === "" || txtKJ.toUpperCase().indexOf(filterJurusan) > -1;

            if (matchNama && matchKelas && matchJurusan) {
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
}
</script>