<?php if(!defined('INDEX')) die(); ?>

<section class="content-header">
    <h1><i class="fa fa-user-plus"></i> Tambah Siswa Baru</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-3">
            <div class="box box-success">
                <div class="box-body box-profile">
                    <img id="preview" class="profile-user-img img-responsive img-bordered" 
                         src="images/nophoto.jpg" 
                         style="width:150px; height:150px; object-fit:cover;" alt="Preview Foto">
                    
                    <h3 class="profile-username text-center">Preview Foto</h3>
                    <p class="text-muted text-center">Pas Foto Formal</p>
                </div>
            </div>
            
            <div class="alert alert-info alert-dismissible">
                <h4><i class="icon fa fa-info"></i> Info</h4>
                Gunakan foto format JPG/PNG dengan ukuran maksimal 1 MB untuk hasil terbaik.
            </div>
        </div>

        <div class="col-md-9">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">Identitas Siswa</h3>
                </div>
                
                <form action="?hal=siswa_insert" method="post" enctype="multipart/form-data" class="form-horizontal">
                    <div class="box-body">
                        
                        <div class="form-group">
                            <label class="col-sm-2 control-label">Pilih Foto</label>
                            <div class="col-sm-10">
                                <input type="file" name="foto" class="form-control" onchange="readURL(this);">
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Nama Lengkap</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-user"></i></span>
                                    <input type="text" name="nama_siswa" class="form-control" placeholder="Masukkan nama lengkap siswa" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">NISN</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-id-card"></i></span>
                                    <input type="text" name="nis" class="form-control" 
                                        placeholder="Masukkan 10 digit NISN..." 
                                        maxlength="11" 
                                        oninput="this.value = this.value.replace(/[^0-9]/g, '');" 
                                        required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Tanggal Lahir</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                                    <input type="date" name="tanggal_lahir" class="form-control" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Kelas</label>
                            <div class="col-sm-10">
                                <label class="radio-inline"><input type="radio" name="kelas" value="10" checked> 10</label>
                                <label class="radio-inline"><input type="radio" name="kelas" value="11"> 11</label>
                                <label class="radio-inline"><input type="radio" name="kelas" value="12"> 12</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Jurusan</label>
                            <div class="col-sm-10">
                                <label class="radio-inline"><input type="radio" name="jurusan" value="PPLG" checked> PPLG</label>
                                <label class="radio-inline"><input type="radio" name="jurusan" value="AKL"> AKL</label>
                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-2 control-label">Gender</label>
                            <div class="col-sm-10">
                                <label class="radio-inline"><input type="radio" name="gender" value="L" checked> Laki-laki</label>
                                <label class="radio-inline"><input type="radio" name="gender" value="P"> Perempuan</label>
                            </div>
                        </div>
                    </div>

                    <div class="box-footer">
                        <div class="pull-right">
                            <a href="?hal=siswa" class="btn btn-default"><i class="fa fa-rotate-left"></i> Kembali</a>
                            <button type="submit" class="btn btn-success"><i class="fa fa-save"></i> Simpan Siswa</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script>
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            $('#preview').attr('src', e.target.result);
        };
        reader.readAsDataURL(input.files[0]);
    }
}
</script>