<?php
if(!defined('INDEX')) die();

$id = mysqli_real_escape_string($con, $_GET['id']);

// 1. Ambil Data Profil Siswa
$query_sis = mysqli_query($con, "SELECT * FROM siswa WHERE id_siswa='$id'");
$s = mysqli_fetch_assoc($query_sis);

if (!$s) {
    echo "<div class='alert alert-danger'>Siswa tidak ditemukan!</div>";
    return;
}

$nis_siswa = trim($s['nis']);

// --- AUTO-SYNC POIN ---
$query_hitung = mysqli_query($con, "SELECT SUM(poin_plg) as total_asli FROM riwayat_pelanggaran WHERE nis='$nis_siswa'");
$data_hitung = mysqli_fetch_assoc($query_hitung);
$total_poin_riwayat = ($data_hitung['total_asli'] != null) ? $data_hitung['total_asli'] : 0;

if ($s['poin_sis'] != $total_poin_riwayat) {
    mysqli_query($con, "UPDATE siswa SET poin_sis='$total_poin_riwayat' WHERE id_siswa='$id'");
    $s['poin_sis'] = $total_poin_riwayat;
}
// ----------------------

// 2. Query Ambil Riwayat (JOIN yang sudah diperbaiki kolomnya)
// r.kode_pl disambungkan ke p.id_pelanggaran
$query_riw = mysqli_query($con, "SELECT r.*, p.nama_pelanggaran 
                                 FROM riwayat_pelanggaran r 
                                 LEFT JOIN pelanggaran p ON r.kode_pl = p.id_pelanggaran 
                                 WHERE r.nis = '$nis_siswa' 
                                 ORDER BY r.tanggal_riw DESC");
?>

<section class="content-header">
    <h1><i class="fa fa-history text-blue"></i> Riwayat Poin: <b><?= $s['nama_siswa'] ?></b></h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-3">
            <div class="box box-primary">
                <div class="box-body box-profile text-center">
                    <?php 
                        $foto = ($s['foto'] != "" && file_exists("images/".$s['foto'])) ? "images/".$s['foto'] : "dist/img/avatar5.png";
                    ?>
                    <img class="profile-user-img img-responsive img-circle" src="<?= $foto ?>" style="width:100px; height:100px; object-fit:cover; margin: 0 auto;">
                    
                    <h3 class="profile-username" style="font-size:18px; margin-top:10px;"><?= $s['nama_siswa'] ?></h3>
                    <p class="text-muted"><?= $nis_siswa ?> | <?= $s['kelas'] ?></p>

                    <ul class="list-group list-group-unbordered text-left">
                        <li class="list-group-item">
                            <b>Total Poin</b> 
                            <span class="pull-right label label-danger" style="font-size:14px"><?= $s['poin_sis'] ?></span>
                        </li>
                    </ul>
                    <a href="?hal=siswa" class="btn btn-default btn-block"><i class="fa fa-arrow-left"></i> Kembali</a>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title">Daftar Pelanggaran</h3>
                </div>
                <div class="box-body table-responsive">
                    <table class="table table-hover table-bordered">
                        <thead>
                            <tr class="bg-blue" style="color:white">
                                <th width="50" class="text-center">No</th>
                                <th width="120" class="text-center">Tanggal</th>
                                <th width="80" class="text-center">ID</th>
                                <th>Keterangan Pelanggaran</th>
                                <th width="80" class="text-center">Poin</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            while($r = mysqli_fetch_array($query_riw)) : 
                            ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td class="text-center"><?= date('d/m/Y', strtotime($r['tanggal_riw'])) ?></td>
                                <td class="text-center"><span class="label label-warning"><?= $r['kode_pl'] ?></span></td>
                                <td>
                                    <?php 
                                        // Menggunakan p.nama_pelanggaran sesuai database
                                        if(!empty($r['nama_pelanggaran'])) {
                                            echo $r['nama_pelanggaran'];
                                        } else {
                                            echo "<i class='text-muted'>Keterangan tidak ditemukan (ID Pelanggaran: ".$r['kode_pl'].")</i>";
                                        }
                                    ?>
                                </td>
                                <td class="text-center text-red"><b>+<?= $r['poin_plg'] ?></b></td>
                            </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>