<?php
if(!defined('INDEX')) die();

// 1. Ambil dan bersihkan data dari form
// NISN: Hanya mengambil angka (0-9)
$nis     = preg_replace("/[^0-9]/", "", $_POST['nis']); 

// NAMA: Hanya mengambil huruf (a-z, A-Z) dan spasi
$nama_raw = $_POST['nama_siswa'];
$nama     = preg_replace("/[^a-zA-Z\s]/", "", $nama_raw);
$nama     = mysqli_real_escape_string($con, $nama);

$tgl     = mysqli_real_escape_string($con, $_POST['tanggal_lahir']);
$kelas   = mysqli_real_escape_string($con, $_POST['kelas']);
$jurusan = mysqli_real_escape_string($con, $_POST['jurusan']);
$gender  = mysqli_real_escape_string($con, $_POST['gender']);

$foto   = $_FILES['foto']['name'];
$lokasi = $_FILES['foto']['tmp_name'];
$tipe   = $_FILES['foto']['type'];
$ukuran = $_FILES['foto']['size'];

$error = "";
$nama_foto_baru = "nophoto.jpg"; 

// ==========================================
// FITUR VALIDASI OTOMATIS
// ==========================================

// A. Validasi NISN: Cek apakah kosong setelah dibersihkan
if(empty($nis)){
    echo "<script>alert('GAGAL! NISN harus diisi dengan angka.'); window.history.back();</script>";
    exit;
}

// B. Validasi Panjang NISN: Maksimal 11 Digit (Boleh 1 digit atau 000)
if(strlen($nis) > 11){
    echo "<script>alert('GAGAL! NISN maksimal 11 digit.'); window.history.back();</script>";
    exit;
}

// C. Validasi Nama: Jika nama menjadi kosong karena isinya angka semua
if(empty(trim($nama))){
    echo "<script>alert('GAGAL! Nama Lengkap hanya boleh berisi huruf.'); window.history.back();</script>";
    exit;
}

// D. Fitur Cek NISN Sudah Ada (Anti Duplikat)
$cek_nis = mysqli_query($con, "SELECT nis, nama_siswa FROM siswa WHERE nis = '$nis'");
if(mysqli_num_rows($cek_nis) > 0){
    $data_ada = mysqli_fetch_array($cek_nis);
    $nama_ada = $data_ada['nama_siswa'];
    echo "<script>alert('PERINGATAN: NISN $nis sudah terdaftar atas nama $nama_ada!'); window.history.back();</script>";
    exit;
}

// ==========================================
// PROSES UPLOAD FOTO
// ==========================================
if($foto != ""){
    $ekstensi_oke = ['image/jpeg', 'image/jpg', 'image/png'];
    if(!in_array($tipe, $ekstensi_oke)){
        $error = "Tipe file tidak didukung! Gunakan JPG atau PNG.";
    } elseif($ukuran >= 2000000){ 
        $error = "Ukuran file terlalu besar (maksimal 2 MB)!";
    } else {
        $ekstensi = pathinfo($foto, PATHINFO_EXTENSION);
        $nama_foto_baru = $nis . "_" . time() . "." . $ekstensi;
        move_uploaded_file($lokasi, "images/" . $nama_foto_baru);
    }
}

// ==========================================
// EKSEKUSI INSERT KE DATABASE
// ==========================================
if($error == ""){
    $query = "INSERT INTO siswa SET 
              foto          = '$nama_foto_baru', 
              nama_siswa    = '$nama', 
              nis           = '$nis', 
              tanggal_lahir = '$tgl', 
              kelas         = '$kelas', 
              jurusan       = '$jurusan', 
              gender        = '$gender',
              poin_sis      = 0";

    $result = mysqli_query($con, $query);

    if($result){
        echo "<div class='alert alert-success' style='margin:20px;'>
                <h4><i class='icon fa fa-check'></i> Berhasil!</h4>
                Siswa <b>$nama</b> dengan NISN <b>$nis</b> telah disimpan.
              </div>";
        echo "<meta http-equiv='refresh' content='2; url=?hal=siswa'>";
    } else {
        echo "<div class='alert alert-danger'>Database Error: " . mysqli_error($con) . "</div>";
    }
} else {
    echo "<script>alert('Error: $error'); window.history.back();</script>";
}
?>