<?php if(!defined('INDEX')) die(); ?>

<style>
/* Style Kotak Kelas agar menarik */
.box-kelas {
    transition: all 0.3s;
    border-radius: 10px !important;
    overflow: hidden;
}
.box-kelas:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.2);
}
/* Memperbaiki foto menjadi kotak formal 90x90 */
.foto-siswa {
    width: 90px !important;
    height: 90px !important;
    object-fit: cover;
    border: 1px solid #ddd;
    border-radius: 4px;
}
</style>

<section class="content-header">
    <h1>
        <i class="fa fa-users text-green"></i> Data Siswa
        <small><?= isset($_GET['kelas']) ? 'Detail Kelas ' . $_GET['kelas'] . ' ' . $_GET['jurusan'] : 'Pilih Kelas' ?></small>
    </h1>
</section>

<section class="content">
    <?php if (!isset($_GET['kelas'])) : ?>
        <div class="row">
            <?php
            // Daftar kategori kelas dan jurusan (bisa diambil dinamis dari DB jika perlu)
            $kategori = [
                ['10', 'PPLG', 'bg-aqua'], ['10', 'AKL', 'bg-aqua'],
                ['11', 'PPLG', 'bg-green'], ['11', 'AKL', 'bg-green'],
                ['12', 'PPLG', 'bg-yellow'], ['12', 'AKL', 'bg-yellow']
            ];

            foreach ($kategori as $k) :
                $kls = $k[0];
                $jrs = $k[1];
                $warna = $k[2];
                
                // Hitung jumlah siswa per kelas untuk ditampilkan di kotak
                $q_hitung = mysqli_query($con, "SELECT COUNT(*) as total FROM siswa WHERE kelas='$kls' AND jurusan='$jrs'");
                $d_hitung = mysqli_fetch_assoc($q_hitung);
            ?>
                <div class="col-md-4 col-sm-6 col-xs-12">
                    <div class="small-box <?= $warna ?> box-kelas">
                        <div class="inner">
                            <h3><?= $kls ?> <span style="font-size: 20px"><?= $jrs ?></span></h3>
                            <p><?= $d_hitung['total'] ?> Siswa Terdaftar</p>
                        </div>
                        <div class="icon">
                            <i class="fa fa-university"></i>
                        </div>
                        <a href="?hal=siswa&kelas=<?= $kls ?>&jurusan=<?= $jrs ?>" class="small-box-footer">
                            Lihat Data Tabel <i class="fa fa-arrow-circle-right"></i>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>

    <?php else : ?>
        <?php
        $kls = mysqli_real_escape_string($con, $_GET['kelas']);
        $jrs = mysqli_real_escape_string($con, $_GET['jurusan']);
        ?>
        
        <div class="row">
            <div class="col-xs-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Daftar Siswa: <b>Kelas <?= $kls ?> <?= $jrs ?></b></h3>
                        <div class="pull-right">
                            <a href="?hal=siswa" class="btn btn-default btn-sm"><i class="fa fa-arrow-left"></i> Kembali</a>
                            <a href="?hal=siswa_tambah" class="btn btn-success btn-sm"><i class="fa fa-plus"></i> Tambah</a>
                            <a href="index.php?hal=rekap_poin&kelas=<?= $kls ?>&jurusan=<?= $jrs ?>" target="_blank" class="btn btn-primary btn-sm">
    <i class="fa fa-print"></i> <b>Cetak Rekap Poin</b>
</a>
                            <a href="?hal=siswa_import" class="btn btn-primary btn-sm"><i class="fa fa-file-excel-o"></i> Import Excel</a>
                        </div>
                    </div>
                    <div class="box-body table-responsive">
                        <table class="table table-bordered table-striped datatable-siswa">
                            <thead>
                                <tr class="bg-blue">
                                    <th width="30">No</th>
                                    <th>Foto</th>
                                    <th>Nama</th>
                                    <th>NIS</th>
                                    <th>Gender</th>
                                    <th>Poin</th>
                                    <th width="80">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = "SELECT * FROM siswa WHERE kelas = '$kls' AND jurusan = '$jrs' ORDER BY nama_siswa ASC";
                                $result = mysqli_query($con, $query);
                                $no = 0;
                                while ($data = mysqli_fetch_array($result)) {
                                    $no++;
                                ?>
                                <tr>
                                    <td><?= $no ?></td>
                                    <td class="text-center">
                                        <img src="images/<?= ($data['foto'] != "") ? $data['foto'] : 'nophoto.jpg' ?>" class="foto-siswa shadow">
                                    </td>
                                    <td><b><?= $data['nama_siswa'] ?></b></td>
                                    <td><code><?= $data['nis'] ?></code></td>
                                    <td><?= $data['gender'] ?></td>
                                    <td>
                                        <span class="label <?= ($data['poin_sis'] > 50) ? 'label-danger' : 'label-info' ?>" style="font-size: 13px;">
                                            <?= number_format(intval($data['poin_sis'])) ?>
                                        </span>
                                    </td>
                                    <td class="text-center">
                                         <a href="?hal=siswa_riwayat&id=<?php echo $data['id_siswa']; ?>" class="btn btn-info btn-xs">
                                          <i class="fa fa-eye"></i> Lihat Riwayat
                                        </a>
                                        <a href="?hal=siswa_edit&id=<?= $data['id_siswa'] ?>" class="btn btn-warning btn-xs" title="Edit"><i class="fa fa-edit"></i></a>
                                        <a href="?hal=siswa_hapus&id=<?= $data['id_siswa'] ?>&foto=<?= $data['foto'] ?>" class="btn btn-danger btn-xs" onclick="return confirm('Yakin hapus data?')" title="Hapus"><i class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</section>

<script>
// Pastikan DataTables dipanggil setelah tabel muncul di DOM
document.addEventListener("DOMContentLoaded", function() {
    if ($.fn.DataTable) {
        $('.datatable-siswa').DataTable({
            "paging": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "language": {
                "search": "Cari Nama/NIS:",
                "lengthMenu": "Tampil _MENU_ data",
                "zeroRecords": "Tidak ada siswa di kelas ini"
            }
        });
    }
});
</script>