<?php if(!defined('INDEX')) die(); ?>

<section class="content-header">
    <h1><i class="fa fa-plus-circle text-green"></i> Input Pelanggaran Siswa</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-4">
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title">Langkah 1: Cari Siswa</h3>
                </div>
                <div class="box-body">
                    <form action="?hal=riwayat_tambah" method="get">
                        <input type="hidden" name="hal" value="riwayat_tambah">
                        <div class="input-group">
                            <input type="text" name="nis" class="form-control" placeholder="Masukkan NISN..." value="<?= @$_GET['nis'] ?>" required>
                            <span class="input-group-btn">
                                <button type="submit" class="btn btn-success btn-flat">Cek Data</button>
                            </span>
                        </div>
                    </form>
                </div>
            </div>

            <?php
            if(isset($_GET['nis'])){
                $nis = $_GET['nis'];
                $query_siswa = mysqli_query($con, "SELECT * FROM siswa WHERE nis='$nis'");
                $data_siswa = mysqli_fetch_array($query_siswa);

                if($data_siswa){
            ?>
            <div class="box box-widget widget-user-2">
                <div class="widget-user-header bg-gray">
                    <div class="widget-user-image">
                        <img class="img-circle" src="images/<?= $data_siswa['foto'] ?>" alt="User Avatar" style="width:65px; height:65px; object-fit:cover;">
                    </div>
                    <h3 class="widget-user-username"><?= $data_siswa['nama_siswa'] ?></h3>
                    <h5 class="widget-user-desc">NISN: <?= $data_siswa['nis'] ?></h5>
                </div>
                <div class="box-footer no-padding">
                    <ul class="nav nav-stacked">
                        <li><a href="#">Kelas <span class="pull-right badge bg-blue"><?= $data_siswa['kelas'] ?></span></a></li>
                        <li><a href="#">Jurusan <span class="pull-right badge bg-aqua"><?= $data_siswa['jurusan'] ?></span></a></li>
                        <li><a href="#">Total Poin Saat Ini <span class="pull-right badge bg-red"><?= $data_siswa['poin_sis'] ?></span></a></li>
                    </ul>
                </div>
            </div>
            <?php 
                } else {
                    echo "<div class='alert alert-danger'>Data siswa tidak ditemukan!</div>";
                }
            } 
            ?>
        </div>

        <div class="col-md-8">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Langkah 2: Pilih Jenis Pelanggaran</h3>
                </div>
                <form action="?hal=riwayat_insert" method="post">
                    <div class="box-body">
                        <?php if(isset($data_siswa) && $data_siswa): ?>
                        <input type="hidden" name="nis" value="<?= $data_siswa['nis'] ?>">
                        <input type="hidden" name="nama" value="<?= $data_siswa['nama_siswa'] ?>">

                        <div class="form-group">
                            <label>Tanggal Melanggar</label>
                            <input type="date" name="tanggal_riw" class="form-control" value="<?= date('Y-m-d') ?>" required>
                        </div>

                        <div class="form-group">
                            <label>Daftar Pelanggaran</label>
                            <select name="id_pelanggaran" class="form-control select2" style="width: 100%;" required>
                                <option value="">- Pilih Pelanggaran -</option>
                                <?php
                                $query_plg = mysqli_query($con, "SELECT * FROM pelanggaran ORDER BY nama_pelanggaran ASC");
                                while($plg = mysqli_fetch_array($query_plg)){
                                    
                                    echo "<option value='$plg[id_pelanggaran]'>$plg[nama_pelanggaran] (Poin: $plg[poin])</option>";
                                }
                                ?>
                            </select>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="fa fa-info-circle"></i> Memilih pelanggaran akan otomatis menambah poin pada data siswa tersebut.
                        </div>

                        <?php else: ?>
                        <div class="text-center" style="padding: 50px 0;">
                            <i class="fa fa-search fa-4x text-gray"></i>
                            <p class="text-muted">Silakan cari NISN siswa terlebih dahulu di kolom kiri.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                    
                    <?php if(isset($data_siswa) && $data_siswa): ?>
                    <div class="box-footer">
                        <button type="submit" class="btn btn-primary btn-block btn-lg"><i class="fa fa-save"></i> SIMPAN PELANGGARAN</button>
                    </div>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>
</section>