<?php
if(!defined('INDEX')) die();

// Query tetap sama dengan logika Anda
$query = "SELECT rp.*, s.kelas, s.jurusan, s.foto 
          FROM riwayat_pelanggaran rp 
          JOIN siswa s ON rp.nis = s.nis 
          ORDER BY rp.id_riwayat DESC"; // Diurutkan dari yang terbaru melanggar
$result = mysqli_query($con, $query);
?>

<section class="content-header">
    <h1><i class="fa fa-warning text-yellow"></i> Log Pelanggaran Siswa</h1>
</section>

<section class="content">
    <div class="box box-primary">
        <div class="box-header with-border">
            <a href="?hal=riwayat_tambah" class="btn btn-success btn-flat"><i class="fa fa-plus"></i> Tambah Riwayat</a>
            
            <div class="box-tools pull-right">
                <div class="form-inline">
                    <select id="filterKelas" class="form-control input-sm" onchange="filterTable()">
                        <option value="">Semua Kelas</option>
                        <?php
                        $kelasQuery = mysqli_query($con, "SELECT DISTINCT kelas FROM siswa");
                        while ($row = mysqli_fetch_array($kelasQuery)) {
                            echo "<option value='".$row['kelas']."'>Kelas ".$row['kelas']."</option>";
                        }
                        ?>
                    </select>
                    <select id="filterJurusan" class="form-control input-sm" onchange="filterTable()">
                        <option value="">Semua Jurusan</option>
                        <?php
                        $jurusanQuery = mysqli_query($con, "SELECT DISTINCT jurusan FROM siswa");
                        while ($row = mysqli_fetch_array($jurusanQuery)) {
                            echo "<option value='".$row['jurusan']."'>".$row['jurusan']."</option>";
                        }
                        ?>
                    </select>
                    <input type="text" id="searchInput" onkeyup="searchTable()" class="form-control input-sm" placeholder="Cari Nama Siswa...">
                </div>
            </div>
        </div>

        <div class="box-body table-responsive no-padding">
            <table id="example2" class="table table-hover table-bordered">
                <thead class="bg-navy">
                    <tr>
                        <th width="30">No</th>
                        <th>Siswa</th>
                        <th>NISN</th>
                        <th>Kelas / Jurusan</th>
                        <th>Waktu Melanggar</th>
                        <th>Kode & Poin</th>
                        <th width="50">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $no = 0;
                    while ($data = mysqli_fetch_array($result)) {
                        $no++;
                        // Warna poin: Merah jika poin tinggi
                        $poin_label = ($data['poin_plg'] >= 50) ? 'label-danger' : 'label-warning';
                    ?>
                    <tr>
                        <td><?= $no ?></td>
                        <td>
                            <div style="display: flex; align-items: center;">
                                <img src="images/<?= $data['foto'] ?>" class="img-circle" style="width:30px; height:30px; margin-right:10px; object-fit:cover;">
                                <div>
                                    <strong><?= $data['nama'] ?></strong>
                                </div>
                            </div>
                        </td>
                        <td><code><?= $data['nis'] ?></code></td>
                        <td><?= $data['kelas'] ?> - <?= $data['jurusan'] ?></td>
                        <td><i class="fa fa-calendar"></i> <?= date('d M Y', strtotime($data['tanggal_riw'])) ?></td>
                        <td>
                            <span class="text-muted"><?= $data['kode_pl'] ?></span> 
                            <span class="label <?= $poin_label ?> pull-right"><?= $data['poin_plg'] ?> Pts</span>
                        </td>
                        <td>
                            <a href="?hal=riwayat_hapus&id=<?= $data['id_riwayat'] ?>" 
                               class="btn btn-danger btn-xs" title="Hapus"
                               onclick="return confirm('Hapus riwayat ini? Poin siswa akan otomatis disesuaikan.')">
                               <i class="fa fa-trash"></i>
                            </a>
                        </td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
</section>

<script>
function searchTable() {
    var input, filter, table, tr, td, i, txtValue;
    input = document.getElementById("searchInput");
    filter = input.value.toUpperCase();
    table = document.getElementById("example2");
    tr = table.getElementsByTagName("tr");
    for (i = 1; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td")[1]; 
        if (td) {
            txtValue = td.textContent || td.innerText;
            tr[i].style.display = (txtValue.toUpperCase().indexOf(filter) > -1) ? "" : "none";
        }       
    }
}

function filterTable() {
    var kelasFilter = document.getElementById("filterKelas").value.toUpperCase();
    var jurusanFilter = document.getElementById("filterJurusan").value.toUpperCase();
    var table = document.getElementById("example2");
    var tr = table.getElementsByTagName("tr");
    for (var i = 1; i < tr.length; i++) {
        var kelasTd = tr[i].getElementsByTagName("td")[3]; 
        if (kelasTd) {
            var text = kelasTd.textContent || kelasTd.innerText;
            var matchKelas = (kelasFilter === "" || text.toUpperCase().indexOf(kelasFilter) > -1);
            var matchJurusan = (jurusanFilter === "" || text.toUpperCase().indexOf(jurusanFilter) > -1);
            tr[i].style.display = (matchKelas && matchJurusan) ? "" : "none";
        }
    }
}
</script>