<?php
if(!defined('INDEX')) die();

// 1. Ambil Parameter & Pastikan Tidak Kosong
$kls = isset($_GET['kelas']) ? mysqli_real_escape_string($con, $_GET['kelas']) : '';
$jrs = isset($_GET['jurusan']) ? mysqli_real_escape_string($con, $_GET['jurusan']) : '';

// 2. Filter Tanggal Mingguan (Default 7 hari terakhir)
$tgl_awal  = isset($_GET['tgl_awal']) ? $_GET['tgl_awal'] : date('Y-m-d', strtotime('-7 days'));
$tgl_akhir = isset($_GET['tgl_akhir']) ? $_GET['tgl_akhir'] : date('Y-m-d');

// 3. Query Siswa - Pastikan variabel $kls dan $jrs ada isinya
$query = mysqli_query($con, "SELECT * FROM siswa WHERE kelas='$kls' AND jurusan='$jrs' ORDER BY nama_siswa ASC");
?>

<style>
.rekap-area { background: #fff; padding: 20px; }
.tabel-cetak { width: 100%; border-collapse: collapse; margin-top: 15px; }
.tabel-cetak th, .tabel-cetak td { border: 1px solid #000 !important; padding: 8px; text-align: center; }
.kop { border-bottom: 3px double #000; padding-bottom: 10px; margin-bottom: 20px; }

@media print {
    .main-header, .main-sidebar, .main-footer, .no-print, .content-header { display: none !important; }
    .content-wrapper { margin-left: 0 !important; padding: 0 !important; border: none !important; }
    body { background: #fff !important; }
}
</style>

<div class="rekap-area">
    <div class="no-print" style="margin-bottom:20px; padding:15px; background:#f4f4f4; border-radius:5px;">
        <form method="GET" class="form-inline">
            <input type="hidden" name="hal" value="rekap_poin">
            <input type="hidden" name="kelas" value="<?= $kls ?>">
            <input type="hidden" name="jurusan" value="<?= $jrs ?>">
            <label>Periode: </label>
            <input type="date" name="tgl_awal" class="form-control input-sm" value="<?= $tgl_awal ?>">
            <input type="date" name="tgl_akhir" class="form-control input-sm" value="<?= $tgl_akhir ?>">
            <button type="submit" class="btn btn-primary btn-sm">Filter Mingguan</button>
            <button type="button" onclick="window.print()" class="btn btn-success btn-sm">Cetak</button>
            <a href="content/rekap_excel.php?kelas=<?= $kls ?>&jurusan=<?= $jrs ?>&tgl_awal=<?= $tgl_awal ?>&tgl_akhir=<?= $tgl_akhir ?>" class="btn btn-success btn-sm">
    <i class="fa fa-file-excel-o"></i> Download Excel
</a>
        </form>
    </div>

    <div class="row kop">
        <div class="col-xs-2"><img src="css/smk.jpg" width="80"></div>
        <div class="col-xs-10 text-center">
            <h3 style="margin:0">SMK BP SUBULUL HUDA</h3>
            <h4 style="margin:5px 0">REKAPITULASI PELANGGARAN: <b><?= $kls ?> <?= $jrs ?></b></h4>
            <p style="margin:0">Periode: <?= date('d/m/Y', strtotime($tgl_awal)) ?> - <?= date('d/m/Y', strtotime($tgl_akhir)) ?></p>
        </div>
    </div>

    <table class="tabel-cetak">
        <thead>
            <tr style="background:#eee!important">
                <th>No</th>
                <th>NIS</th>
                <th>Nama Siswa</th>
                <th>Poin Baru</th>
                <th>Keterangan (Kode Pelanggaran)</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $no = 1;
            while($d = mysqli_fetch_array($query)) : 
                $nis = $d['nis'];
                // Query hitung poin per periode
                $q_riw = mysqli_query($con, "SELECT SUM(poin_plg) as total, GROUP_CONCAT(kode_pl) as rincian 
                                            FROM riwayat_pelanggaran 
                                            WHERE nis='$nis' AND (tanggal_riw BETWEEN '$tgl_awal' AND '$tgl_akhir')");
                $r = mysqli_fetch_assoc($q_riw);
                $p_minggu = $r['total'] ? $r['total'] : 0;
            ?>
            <tr>
                <td><?= $no++ ?></td>
                <td><?= $d['nis'] ?></td>
                <td style="text-align:left"><?= strtoupper($d['nama_siswa']) ?></td>
                <td><b>+<?= $p_minggu ?></b></td>
                <td style="text-align:left; font-size:10px"><?= $r['rincian'] ? $r['rincian'] : '-' ?></td>
            </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>