<?php
if(!defined('INDEX')) die();
?>

<section class="content">
  <div class="row">
    <div class="col-xs-12">
      
      <div class="box box-primary">
        <div class="box-header with-border">
          <h3 class="box-title">Data Pelanggaran</h3>
        </div>

        <div class="box-body table-responsive">
          <div style="margin-bottom: 15px;">
            <a href="?hal=pelanggaran_tambah" class="btn btn-success">
              <i class="fa fa-plus"></i> <b>Tambah Pelanggaran</b>
            </a>
          </div>

          <table id="example1" class="table table-bordered table-striped">
            <thead>
              <tr>
                <th width="5%">No</th>
                <th>Nama Pelanggaran</th>
                <th>Jenis Pelanggaran</th>
                <th>Poin</th>
                <th>Kode PL</th>
                <th width="15%">Action</th>
              </tr>
            </thead>
            <tbody>
              <?php
                // Mengambil data dari tabel pelanggaran
                $query = "SELECT * FROM pelanggaran ORDER BY id_pelanggaran DESC";
                $result = mysqli_query($con, $query);
                $no = 0;
                
                while($data = mysqli_fetch_array($result)){
                  $no++;
                  $jenis = $data['jenis_pelanggaran']; // Mengambil nilai jenis
                  
                  // Menentukan warna badge berdasarkan jenis pelanggaran
                  if(strtolower($jenis) == "ringan") {
                      $badge = "label-success"; // Hijau
                  } elseif(strtolower($jenis) == "sedang") {
                      $badge = "label-warning"; // Kuning
                  } elseif(strtolower($jenis) == "berat") {
                      $badge = "label-danger";  // Merah
                  } else {
                      $badge = "label-default"; // Abu-abu
                  }
              ?>
              <tr>
                <td><?= $no ?></td>
                <td><?= $data['nama_pelanggaran'] ?></td>
                <td>
                  <span class="label <?= $badge ?>"><?= $jenis ?></span>
                </td>
                <td><span class="badge bg-purple"><?= $data['poin'] ?></span></td>
                <td><code><?= $data['kode'] ?></code></td>
                <td>
                  <a href="?hal=pelanggaran_edit&id=<?= $data['id_pelanggaran'] ?>" class="btn btn-primary btn-sm">
                    <i class="fa fa-edit"></i> Edit
                  </a>
                  <a href="?hal=pelanggaran_hapus&id=<?= $data['id_pelanggaran'] ?>" 
                     class="btn btn-danger btn-sm" 
                     onclick="return confirm('Yakin ingin menghapus data ini?')">
                    <i class="fa fa-trash"></i> Hapus
                  </a>
                </td>
              </tr>
              <?php
                } // Penutup perulangan while
              ?>
            </tbody>
          </table>
        </div>
        </div>
      </div>
  </div>
</section>

<script>
  $(function () {
    $('#example1').DataTable({
      "paging": true,
      "lengthChange": true,
      "searching": true,
      "ordering": true,
      "info": true,
      "autoWidth": false
    });
  });
</script>