<?php if (!defined('INDEX')) die(); ?>

<section class="content-header">
    <h1><i class="fa fa-list text-blue"></i> Master Macam Tebusan</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <div class="row">
                        <div class="col-md-6">
                            <a href="?hal=pebus_tambah" class="btn btn-success">
                                <i class="fa fa-plus"></i> Tambah Macam Tebusan
                            </a>
                        </div>
                        <div class="col-md-6 text-right">
                             <input type="text" id="searchTebus" onkeyup="filterTebus()" placeholder="Cari nama tebusan..." class="form-control" style="width: 250px; display:inline-block;">
                        </div>
                    </div>
                </div>

                <div class="box-body table-responsive no-padding">
                    <table id="tableMasterTebus" class="table table-hover table-striped">
                        <thead>
                            <tr style="background-color: #3c8dbc; color: white;">
                                <th width="50" class="text-center">No</th>
                                <th>Nama Aksi / Penebusan</th>
                                <th class="text-center">Nilai Poin (Pengurangan)</th>
                                <th class="text-center">Kode</th>
                                <th width="120" class="text-center">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query = "SELECT * FROM tebus ORDER BY id_tebus DESC";
                            $result = mysqli_query($con, $query);
                            $no = 0;
                            while($data = mysqli_fetch_array($result)){
                                $no++;
                            ?>
                            <tr>
                                <td class="text-center"><?= $no ?></td>
                                <td><b><?= $data['nama_tebus'] ?></b></td>
                                <td class="text-center">
                                    <span class="label label-success" style="font-size: 13px;">
                                        <i class="fa fa-minus"></i> <?= $data['poin_tebus'] ?> Pts
                                    </span>
                                </td>
                                <td class="text-center"><code style="color: #333;"><?= $data['kode_tebus'] ?></code></td>
                                <td class="text-center">
                                    <a href="?hal=pebus_hapus&id=<?= $data['id_tebus'] ?>" 
                                       class="btn btn-danger btn-xs" 
                                       onclick="return confirm('Apakah Anda yakin ingin menghapus jenis tebusan ini?')">
                                        <i class="fa fa-trash"></i> Hapus
                                    </a>
                                </td>
                            </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
                <div class="box-footer">
                    <small class="text-muted">* Poin yang tertera di atas akan mengurangi total poin pelanggaran siswa saat digunakan.</small>
                </div>
            </div>
        </div>
    </div>
</section>

<script>
function filterTebus() {
    var input, filter, table, tr, td, i, txtValue;
    input = document.getElementById("searchTebus");
    filter = input.value.toUpperCase();
    table = document.getElementById("tableMasterTebus");
    tr = table.getElementsByTagName("tr");

    for (i = 1; i < tr.length; i++) {
        td = tr[i].getElementsByTagName("td")[1]; // Kolom Nama Penebusan
        if (td) {
            txtValue = td.textContent || td.innerText;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                tr[i].style.display = "";
            } else {
                tr[i].style.display = "none";
            }
        }
    }
}
</script>