<?php
if (!defined('INDEX')) die("");

// Logika Role tetap sesuai system asli Anda
switch ($_SESSION['role']) {
    case '55':
        $role = "Administrator";
        $color = "text-red";
        break;
    case '66':
        $role = "Operator";
        $color = "text-yellow";
        break;
    case '77':
        $role = "Owner";
        $color = "text-blue";
        break;
    default:
        $role = "User";
        $color = "text-gray";
        break;
}

// Mengambil jumlah total pelanggaran - Menggunakan COUNT(*) agar lebih cepat
$query_pelanggaran = mysqli_query($con, "SELECT COUNT(*) as total FROM pelanggaran");
$data_p = mysqli_fetch_assoc($query_pelanggaran);
$jml_pelanggaran = $data_p['total'];

// Mengambil jumlah total siswa
$query_siswa = mysqli_query($con, "SELECT COUNT(*) as total FROM siswa");
$data_s = mysqli_fetch_assoc($query_siswa);
$jml_siswa = $data_s['total'];

// Tambahan: Mengambil data penebusan (opsional untuk memperkaya dashboard)
$query_tebus = mysqli_query($con, "SELECT COUNT(*) as total FROM rw_tebus");
$data_t = mysqli_fetch_assoc($query_tebus);
$jml_tebus = $data_t['total'] ?? 0;
?>

<section class="content-header">
    <h1>
        Dashboard
        <small>Control Panel</small>
    </h1>
    <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Dashboard</li>
    </ol>
</section>

<section class="content">
    <div class="row">
        <div class="col-lg-4 col-xs-6">
            <div class="small-box bg-aqua shadow">
                <div class="inner">
                    <h3><?= $jml_pelanggaran ?></h3>
                    <p>Total Jenis Pelanggaran</p>
                </div>
                <div class="icon">
                    <i class="fa fa-gavel"></i>
                </div>
                <a href="?hal=pelanggaran" class="small-box-footer">Selengkapnya <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-4 col-xs-6">
            <div class="small-box bg-green shadow">
                <div class="inner">
                    <h3><?= $jml_siswa ?></h3>
                    <p>Siswa Terdaftar</p>
                </div>
                <div class="icon">
                    <i class="fa fa-users"></i>
                </div>
                <a href="?hal=siswa" class="small-box-footer">Selengkapnya <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>

        <div class="col-lg-4 col-xs-12">
            <div class="small-box bg-yellow shadow">
                <div class="inner">
                    <h3><?= $jml_tebus ?></h3>
                    <p>Riwayat Penebusan</p>
                </div>
                <div class="icon">
                    <i class="fa fa-heart"></i>
                </div>
                <a href="?hal=tebus" class="small-box-footer">Selengkapnya <i class="fa fa-arrow-circle-right"></i></a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8">
            <div class="box box-solid bg-teal-gradient">
                <div class="box-header">
                    <i class="fa fa-th"></i>
                    <h3 class="box-title">Selamat Datang</h3>
                </div>
                <div class="box-body border-radius-none">
                    <div style="padding: 20px;">
                        <h2 style="margin-top: 0;">Hai, <b><?= $_SESSION['nama'] ?></b> ☺️</h2>
                        <p style="font-size: 1.2em;">
                            Selamat datang di <b>Syinpewa</b> (System Informasi Poin Pelanggaran).<br>
                            Saat ini Anda memiliki akses sebagai <b class="label label-danger"><?= $role ?></b>.
                        </p>
                    </div>
                </div>
                <div class="box-footer no-border" style="color: #444;">
                    <div class="row">
                        <div class="col-xs-12">
                            <i class="fa fa-info-circle"></i> Gunakan menu di sebelah kiri untuk mengelola data poin secara bijak dan transparan.
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Info Login</h3>
                </div>
                <div class="box-body box-profile">
                    <img class="profile-user-img img-responsive img-circle" src="images/default.png" alt="User profile picture">
                    <h3 class="profile-username text-center"><?= $_SESSION['nama'] ?></h3>
                    <p class="text-muted text-center"><?= $role ?></p>

                    <ul class="list-group list-group-unbordered">
                        <li class="list-group-item">
                            <b>Waktu Login</b> <a class="pull-right"><?= date('H:i') ?> WIB</a>
                        </li>
                        <li class="list-group-item">
                            <b>Tanggal</b> <a class="pull-right"><?= date('d M Y') ?></a>
                        </li>
                    </ul>
                    <a href="logout.php" class="btn btn-danger btn-block"><b>Keluar</b></a>
                </div>
            </div>
        </div>
    </div>
</section>